<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
* @filesource
*//** */


// This can be removed if you use Modular Extensions
require_once APPPATH.'/libraries/REST_Controller.php';
require_once APPPATH.'/third_party/Paginator.php';
require_once APPPATH.'/third_party/WkHtmlToPdf.php';
require_once 'admin_controller.php';
/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Reports extends Admin_controller
{
	var $report_tabs = array("requests"=>"Requests", "events"=>"Events","logins"=>"Logins","mail"=>"Mail","user_activity_summary"=>"User Summary","facility"=>"Facility","hisp"=>"HISP","points_of_origin"=>"Points of Origin");
	public function __construct(){
		parent::__construct();
		$this->load->library(array('session','encrypt','eventlog','permissions','auth','locale'));
		$models = array('applicationmodel','applicationrequestmodel','facilitymodel','requestmodel','usersmodel','loginsmodel','mailmodel','ticketsmodel','pointsoforiginmodel','hispmodel','useractivitysummarymodel','ticketcategorymodel');
		foreach($models as $model) {
			$this->load->model($model);
		}
		
		date_default_timezone_set(ENVIRONMENT_TIMEZONE);
		//set fileDownloadToken, so the system is able to detect when the file downloading window for pdf export returns
		setcookie('fileDownloadToken', true, time() + 60 * 60 * 24 * 7);
	}
	
	public function index() {
		//get user id from session to get permissions
		$permissions = $this->account_permissions;
		$show = $this->show;
		foreach ($this->report_tabs as $key=>$value){
			if($this->has_access($key."_report")){
				$report = "report_".$key;
				$this->$report();
				return;
			}
		}
		redirect('onboarding');
	}
	
	/* -----------------------------*
	 *  REPORTS TAB FUNCTIONS       *
	 * -----------------------------*/

	public function report_requests(){
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
		
		$data = array(
			'title' => 'Direct API: Reports',
			'active_tab' => array('reports'=>true),
			'timezone_abbr' => $this->locale->timezone_abbr_from_name(date_default_timezone_get()),
			'tabs' => $this->create_tabs('requests_report'),
			'report_name' => 'requests',
			'show' => $this->show,
			'time' => date('m/d/Y h:i:s A', time()),
			'user' => $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'],
		);
		//get user id from session to get permissions
		$permissions = $this->account_permissions;
		$selected = null;
		$responses_list = $response_export_list = array();
		//show forbidden if the user does not have permission to be here
		if(!$data['show']['reports']) { show_error('Forbidden',403);  }
		//gets selected application
		$app_select = $this->input->post('whichapp',TRUE); 
		//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
		if($app_select) {
			//adds each component type into its own json
			$selector = array(
				'application_id' => ($app_select),
			);
			
			$items = array(
				'id' => $this->search_type($this->input->post('request_id',TRUE),$this->input->post('request_id_type',TRUE)),
				'call' => $this->search_type($this->input->post('request_call',TRUE),$this->input->post('request_call_type',TRUE)),
				'response_code' => $this->search_type($this->input->post('request_code',TRUE),$this->input->post('request_code_type',TRUE)),
				'response' => $this->search_type($this->input->post('request_response',TRUE),$this->input->post('request_response_type',TRUE)),
			);
			
			$end_date = $this->input->post('end_date',TRUE);
			$start_date = $this->input->post('start_date',TRUE);
			$date_array = array($end_date, $start_date);
			$date_warning_message = $this->get_date_filter_validation_message($date_array);
			
			$between = array(
				'call_date' => $this->check_date($start_date,$end_date),
			);
			//get direction (desc/asc)and if it is being exported
			$dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
			$export = $this->input->post('export',TRUE);
			$export_pdf = $this->input->post('export_pdf',TRUE);
			$print_page = $this->input->post('print_page',TRUE);
			$is_export = ($export || $export_pdf || $print_page) ? TRUE : FALSE;
			$data['is_export'] = $is_export;
			//calls helper to get data
			$response = $this->reports_helper('request',$items,$between,$selector,array(),$this->input->post('order',TRUE),$dir,$destination_page,$is_export,$items_per_page);
			$responses_list = $response['response'];
			//set form data
			$form_data = $this->input->post(NULL,TRUE);
			$form_data['direction'] = $dir;
			$form_data['cur_page'] = $destination_page;
			$form_data['date_warning_message'] = $date_warning_message;
			
			$size = $response['size'];
			if($selector['application_id'] != '(ALL)') $selected = 'Application: ' . $this->applicationmodel->get_application_name_by_id($selector['application_id'])->result()[0]->name;
			$data['filters'] = $this->export_info($items,$between,$selected,null);
			if($is_export == TRUE){
				//ExportPDF-PRINT
				$response_export = $this->reports_helper('request',$items,$between,$selector,array(),$this->input->post('order',TRUE),$dir,$destination_page,$is_export,$size);
				$response_export_list = $response_export['response'];
			}
		}
		//if this is the first time you have loaded the page
		else {
			$responses_list = $this->requestmodel->get_first_responses($items_per_page)->result(); //gets first page
			//set defaults
			$form_data = array(
			 'direction' => 'DESC',
			 'order' => 'call_date',
			 'cur_page' => '1',
			);
			//get number of items in log
			$size = $this->requestmodel->get_size()->result();
			$size = $size[0]->count;
			$export = false;
			$export_pdf = FALSE;
			$print_page = FALSE;
		}
		//set options for comparing
		$data['compare'] = array(
			'equals' => 'Equals',
			'contains' => 'Contains',
			'starts' => 'Starts With',
			'ends' => 'Ends With'
		);
		
		//pagination setup
		$pages->items_total = $size;
		$pages->current_page = $destination_page;
		$pages->paginate();
		$form_data['pagination_bar'] = $pages->display_pages();
		$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
		
		//gets image for asc or desc
		if($form_data['direction'] == 'DESC') { $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>'; }
		else { $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>'; }
		
		$form_data['num_pages'] = ceil($size/$items_per_page); //num of log pages
		$form_data['items_per_page'] = $items_per_page;
		$form_data['pages'] = $pages;
		$data['form_data'] = $form_data;
		$data['apps'] = $this->applicationmodel->get_applications()->result(); //gets all applications available
		$data['request_list'] = $responses_list;
		
		$lists = array($responses_list, $response_export_list);
		foreach($lists as $list) {
			if(isset($list)) {
				foreach($list as $result) {
					//converts application's numbers into their names
					$name = $this->id_to_name(2,$result->application_id);
					$result->application_id=$name['id'];
				
					//set time in more readable format 
					if($result->call_date){ $result->call_date = date('m/d/y h:i:s A',$result->call_date); }
				}
			}
		}
		
		//if exported
		if ($export){ 
			if (!empty($response_export)){ $responses_list = $response_export_list; }
			else { $responses_list = $responses_list; }
			$this->export(array('ID','Application','Call','Date ('.$data['timezone_abbr'].')','Response Code','Response'),$responses_list,'response_log',$items,$between,$selected,null); 
		}
		else if($export_pdf) {
			if(!empty($response_export)) { $data['request_list'] = $response_export_list; }
			else { $data['request_list'] = $responses_list; }
			$html = $this->load->view('api/reports/result_tables/result_requests', $data, true);
			$this->export_pdf('Requests Report.pdf', $html);
		}
		else if($print_page) {
			if (!empty($response_export)){ $data['request_list'] = $response_export_list; } 
			else { $data['request_list'] = $responses_list; }
			$this->clear_cache();
			$data['print_page'] = true;
			$this->load->view('api/reports/result_tables/result_requests', $data);
		}
		//display on page
		else { $this->load->view('api/reports/requests', $data); }
	}
	
	//function for tickets report
	public function report_tickets(){
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
	
		$data['title'] = 'Direct API: Reports';
		$data['active_tab'] = array('reports'=>true);
		$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
		$data['tabs'] = $this->create_tabs("tickets_report");
		//get user id from session to get permissions
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['time'] = date('m/d/Y h:i:s A', time());
		$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
		$selected=null;
	
		if(!$data['show']['reports']) { show_error('Forbidden',403);  }
		$category = $this->input->post('ticket_category',TRUE);//gets select ticket category
		if($category){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
			//adds each component type into its own json
			$selector = array(
					'category_id' => ($category),
			);
				
			$items = array(
					'id' => $this->search_type($this->input->post('ticket_id',TRUE),$this->input->post('ticket_id_type',TRUE)),
					'parent_id' => $this->search_type($this->input->post('ticket_parent',TRUE),$this->input->post('ticket_parent_type',TRUE)),
					'message' => $this->search_type($this->input->post('ticket_message',TRUE),$this->input->post('ticket_message_type',TRUE)),
			);
			$extra_items = array(
					'id' => $this->search_type($this->input->post('ticket_id',TRUE),$this->input->post('ticket_id_type',TRUE)),
					'parent_id' => $this->search_type($this->input->post('ticket_parent',TRUE),$this->input->post('ticket_parent_type',TRUE)),
					'message' => $this->search_type($this->input->post('ticket_message',TRUE),$this->input->post('ticket_message_type',TRUE)),
					'user_id' => $this->search_type($this->input->post('ticket_user',TRUE),$this->input->post('ticket_user_type',TRUE)),
			);
			$open_start_date = $this->input->post('open_start_date',TRUE);
			$open_end_date = $this->input->post('open_end_date',TRUE);
			$close_start_date = $this->input->post('close_start_date',TRUE);
			$close_end_date = $this->input->post('close_end_date',TRUE);
			$date_array = array($open_start_date, $open_end_date, $close_start_date, $close_end_date);
			$date_warning_message = $this->get_date_filter_validation_message($date_array);
			
			$between = array(
					'open_date' => $this->check_date($open_start_date,$open_end_date),
					'close_date' => $this->check_date($close_start_date,$close_end_date),
			);
			
			$typesearch = array (
					'user_id' => array(
							'typesql' => null,
							'name' => $this->search_type($this->input->post('ticket_user',TRUE),$this->input->post('ticket_user_type',TRUE)),
							'type' => 3
					)
			);
			
			//get direction (desc/asc)and if it is being exported
			$dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
			$export = $this->input->post('export',TRUE);
			$export_pdf = $this->input->post('export_pdf',TRUE);
			$print_page = $this->input->post('print_page',TRUE);
			$is_export = 0;
			if($export) {
				$is_export = 'excel';
			}
			else if($export_pdf) {
				$is_export = 'pdf';
			}
			else if($print_page) {
				$is_export = 'print';
			}
			$data['is_export'] = $is_export;
			//calls helper to get data
			$response = $this->reports_helper('tickets',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$items_per_page);
			$responses_list = $response['response'];
			//set form data
			$form_data = $this->input->post(NULL,TRUE);
			$form_data['direction'] = $dir;
			$form_data['cur_page'] = $destination_page;
			$form_data['date_warning_message'] = $date_warning_message;
			$size = $response['size'];
			if($selector['category_id'] != '(ALL)') $selected = 'Category: ' . $this->ticketcategorymodel->get_category($selector['category_id'])->result()[0]->category;
			//ExportPDF-PRINT
			$response_export = $this->reports_helper('tickets',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$size);
			$response_export_list = $response_export['response'];
			$data['filters'] = $this->export_info($extra_items,$between,$selected,null);
		}
		else{//if this is the first time you have loaded the page
			$responses_list = $this->ticketsmodel->get_first_responses($items_per_page)->result();//gets first page
			//set defaults
			$form_data = array(
				 'direction' => 'DESC',
				 'order' => 'open_date',
				 'cur_page' => '1',
			);
			//get number of items in log
			$size = $this->ticketsmodel->get_size()->result();
			$size = $size[0]->count;
			$export = FALSE;
			$export_pdf = FALSE;
			$print_page = FALSE;
		}
		//set options for comparing
		$data['compare'] = array(
				'equals' => 'Equals',
				'contains' => 'Contains',
				'starts' => 'Starts With',
				'ends' => 'Ends With'
		);
	
		//pagination setup
		$pages->items_total = $size;
		$pages->current_page = $destination_page;
		$pages->paginate();
		$form_data['pagination_bar'] = $pages->display_pages();
		$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
	
		//gets image for asc or desc
		if($form_data['direction'] == 'DESC') { $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>'; }
		else { $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>'; }
	
		$form_data['num_pages'] = ceil($size/$items_per_page); //num of log pages
		$form_data['items_per_page'] = $items_per_page;
		$form_data['pages'] = $pages;
		$data['form_data'] = $form_data;
		$data['categories'] = $this->ticketcategorymodel->get_categories()->result(); //gets all categories available
		$data['ticket_list'] = $responses_list;
		
		foreach($responses_list as $result) {
			
			//pull username from system (user type is 3)
			if ($result->user_id){
				$value = $this->id_to_name(3,$result->user_id);
				$result->user_id = $value['id'];
			}
			
			//pull category name from system (category type is is 5)
			if ($result->category_id){
				$value = $this->id_to_name(5,$result->category_id);
				$result->category_id = $value['id'];
			}
			
			//set time in more readable format
			if($result->open_date){ $result->open_date = date('m/d/y h:i:s A',$result->open_date); }
			if($result->close_date){ $result->close_date = date('m/d/y h:i:s A',$result->close_date); }
		}
		//if export
		if($export){
			$this->export(array('ID','Parent','User','Message','Open Date ('.$data['timezone_abbr'].')','Close Date ('.$data['timezone_abbr'].')','Category'),$responses_list,'ticket_log',$extra_items,$between,$selected,null); 
		}
		else if($export_pdf) {
			if (!empty($response_export)){
				$data['ticket_list'] = $response_export_list;
			} else {
				$data['ticket_list'] = $responses_list;
			}
			foreach($data['ticket_list'] as $result) {
			//pull username from system (user type is 3)
			if ($result->user_id){
				$value = $this->id_to_name(3,$result->user_id);
				$result->user_id = $value['id'];
			}
			//pull category name from system (category type is is 5)
			if ($result->category_id){
				$value = $this->id_to_name(5,$result->category_id);
				$result->category_id = $value['id'];
			}
			//set time in more readable format
			if($result->open_date){ $result->open_date = date('m/d/y h:i:s A',$result->open_date); }
			if($result->close_date){ $result->close_date = date('m/d/y h:i:s A',$result->close_date); }
			}
			$report_content = $this->input->post('report_content',TRUE);
			$html = $this->load->view('api/reports/result_tables/result_tickets', $data, true);
			$this->export_pdf('Tickets Report.pdf', $html);
		}
		else if($print_page) {
			$this->clear_cache();
			if (!empty($response_export)){
				$data['ticket_list'] = $response_export_list;
			} else {
				$data['ticket_list'] = $responses_list;
			}
			foreach($data['ticket_list'] as $result) {
			//pull username from system (user type is 3)
			if ($result->user_id){
				$value = $this->id_to_name(3,$result->user_id);
				$result->user_id = $value['id'];
			}
			//pull category name from system (category type is is 5)
			if ($result->category_id){
				$value = $this->id_to_name(5,$result->category_id);
				$result->category_id = $value['id'];
			}
			//set time in more readable format
			if($result->open_date){ $result->open_date = date('m/d/y h:i:s A',$result->open_date); }
			if($result->close_date){ $result->close_date = date('m/d/y h:i:s A',$result->close_date); }
			}
			$data['print_page'] = true;
			$this->load->view('api/reports/result_tables/result_tickets', $data);
		}
		else{
			$this->load->view('api/reports/tickets', $data);
		}
	}
	
	//function for events report
	public function report_events(){
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
		
		$data['title'] = 'Direct API: Reports';
		$data['active_tab'] = array('reports'=>true);
		$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
		$data['tabs'] = $this->create_tabs("events_report");
		//get user id from session to get permissions
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['time'] = date('m/d/Y h:i:s A', time());
		$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
		$response_export_list = $event_list = array();
		$selected = array();
		
		if(!$data['show']['reports']) { show_error('Forbidden',403); }
		$target_type = $this->input->post('target_type',TRUE);//gets selected 
		if($target_type){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
			//adds each component type into its own json
			$selector = array(
				'success' =>  $this->input->post('successful',TRUE),
			);
			
			$items = array(
				'id' => $this->search_type($this->input->post('event_id',TRUE),$this->input->post('event_id_type',TRUE)),
				'action' => $this->search_type($this->input->post('action',TRUE),$this->input->post('action_type',TRUE)),
			);
			$extra_items = array(
				'id' => $this->search_type($this->input->post('event_id',TRUE),$this->input->post('event_id_type',TRUE)),
				'action' => $this->search_type($this->input->post('action',TRUE),$this->input->post('action_type',TRUE)),
				'actor' => $this->search_type($this->input->post('acting_user',TRUE),$this->input->post('acting_user_type',TRUE)),
				'target' => $this->search_type($this->input->post('target_user',TRUE),$this->input->post('target_user_type',TRUE)),
			);
			$end_date = $this->input->post('end_date',TRUE);
			$start_date= $this->input->post('start_date',TRUE);
			$date_array = array($end_date, $start_date);
			$date_warning_message = $this->get_date_filter_validation_message($date_array);
			
			$between = array(
				'event_date' => $this->check_date($start_date,$end_date),
			);
			
			$typesearch = array (
				'actor_id'	=> array (
					'typesql' => 'actor_type',
					'name' => $this->search_type($this->input->post('acting_user',TRUE),$this->input->post('acting_user_type',TRUE)),
					'type' => $this->input->post('acting_type',TRUE),		
				),
				'target_id' => array(
					'typesql' => 'target_type',
					'name' => $this->search_type($this->input->post('target_user',TRUE),$this->input->post('target_user_type',TRUE)),
					'type' => $this->input->post('target_type',TRUE),
				),
			);
			//set options for comparing
				$data['compare'] = array(
						'equals' => 'Equals',
						'contains' => 'Contains',
						'starts' => 'Starts With',
						'ends' => 'Ends With'
				);
			//get direction and if it is supported
			$dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
			$export = $this->input->post('export',TRUE);
			$export_pdf = $this->input->post('export_pdf',TRUE);
			$print_page = $this->input->post('print_page',TRUE);
			$is_export = 0;
			if($export) { $is_export = 'excel'; }
			else if($export_pdf) { $is_export = 'pdf'; }
			else if($print_page) { $is_export = 'print'; }
			$data['is_export'] = $is_export;
			
			//get data
			$response = $this->reports_helper('event',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$items_per_page);
			$event_list = $response['response'];
			$form_data = $this->input->post(NULL,TRUE);
			$form_data['direction'] = $dir;
			$form_data['cur_page'] = $destination_page;
			$form_data['date_warning_message'] = $date_warning_message;
			$size = $response['size'];
			if($selector['success'] == 1) { array_push($selected, 'Success: True'); }
			else if($selector['success'] == '(ALL)') { array_push($selected, null); }
			else { array_push($selected, 'Success: False'); }
			if(isset($typesearch['actor_id']['type']) && $typesearch['actor_id']['type'] == '(ALL)') array_push($selected, null);
			else { array_push($selected, 'Actor Type: '. $this->get_type($typesearch['actor_id']['type'])); }
			if(isset($typesearch['target_id']['type']) && $typesearch['target_id']['type'] == '(ALL)') { array_push($selected, null); }
			else { array_push($selected, 'Target Type: '. $this->get_type($typesearch['target_id']['type'])); }
			
			//Export PDF-PRINT
			$response_export = $this->reports_helper('event',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$size);
			$response_export_list = $response_export['response'];
			$data['filters'] = $this->export_info($extra_items, $between, $selected, null);
		}
		else { //if this is the first time you have loaded the page (ie no filters have fields)
			$event_list = $this->eventmodel->get_first_events($items_per_page)->result();
			//set defaults
			$form_data = array(
			 'direction' => 'DESC',
			 'order' => 'event_date',
			 'cur_page' => '1',
			);
			//get number of items in log
			$size = $this->eventmodel->get_size()->result();
			$size = $size[0]->count;
			$export = FALSE;
			$export_pdf = FALSE;
			$print_page = FALSE;
		}
		//set options for comparing
		$data['compare'] = array(
			'equals' => 'Equals',
			'contains' => 'Contains',
			'starts' => 'Starts With',
			'ends' => 'Ends With'
		);
		
		//pagination setup
		$pages->items_total = $size;
		$pages->current_page = $destination_page;
		$pages->paginate();
		$form_data['pagination_bar'] = $pages->display_pages();
		$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
		
		//gets image for asc or desc
		if($form_data['direction'] == 'DESC') { $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>'; }
		else { $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>'; }
		
		$form_data['num_pages'] = ceil($size/$items_per_page); //num of log pages
		$form_data['items_per_page'] = $items_per_page;
		$form_data['pages'] = $pages;
		$data['form_data'] = $form_data;
		$data['event_list'] = $event_list;
		
		//loop through both export and normal responses to report query to convert values as needed
		$lists = array($event_list, $response_export_list);
		foreach($lists as $list) {
			if(isset($list)) {
				foreach($list as $event) {
					//converts actor and target ids into their display names
					$value = $this->id_to_name($event->actor_type,$event->actor_id);
					$event->actor_type=$value['type'];
					$event->actor_id=$value['id'];
					$value = $this->id_to_name($event->target_type,$event->target_id);
					$event->target_type=$value['type'];
					$event->target_id=$value['id'];
					//changes success integer into true, false or unauth
					if($event->success === 1) { $event->success = 'TRUE'; }
					else if($event->success === 2){ $event->success = 'UNAUTH'; }
					else{ $event->success = 'FALSE'; }
					
					//change date into readable
					$event->event_date = date('m/d/y h:i:s A',$event->event_date);
				}
			}
		}
		
		//if export
		if($export){
			$this->export(array('ID','Target Type','Target','Actor Type','Actor','Action','Date ('.$data['timezone_abbr'].')','Success'),$event_list,'events_log',$extra_items,$between,$selected,null);
		}
		else if($export_pdf) {
			if (!empty($response_export)) { $data['event_list'] = $response_export_list; } 
			else { $data['event_list'] = $event_list; }
			$report_content = $this->input->post('report_content',TRUE);
			$html = $this->load->view('api/reports/result_tables/result_events', $data, true);
			$this->export_pdf('Events Report.pdf', $html);
		}
		else if($print_page) {
			$this->clear_cache();
			if (!empty($response_export)){ $data['event_list'] = $response_export_list; }
			else { $data['event_list'] = $event_list; }
			$data['print_page'] = true;
			$this->load->view('api/reports/result_tables/result_events', $data);
		}
		else{
			$this->load->view('api/reports/events', $data);
		}

	}
	//function for logins report
	public function report_logins(){
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
		
		$data['title'] = 'Direct API: Reports';
		$data['active_tab'] = array('reports'=>true);
		$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
		$data['tabs'] = $this->create_tabs("logins_report");
		//get user id from session to get permissions
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['time'] = date('m/d/Y h:i:s A', time());
		$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
		$selected = null;
		
		if(!$data['show']['reports']) {
			show_error('Forbidden',403); 
		}
		$id_type = $this->input->post('id_type',TRUE); //gets selected 
		if($id_type) { // This shows whether or not this is the first time the page has loaded.
			//adds each component type into its own json
			$selector = array(
				'success' =>  $this->input->post('successful',TRUE),
			);
			
			$items = array(
				'id' => $this->search_type($this->input->post('id',TRUE),$this->input->post('id_type',TRUE)),
				'session_id'=>$this->search_type($this->input->post('session_id',TRUE),$this->input->post('session_id_type',TRUE)),
				'ip_address'=>$this->search_type($this->input->post('ip_address',TRUE),$this->input->post('ip_address_type',TRUE)),
				'error_msg'=>$this->search_type($this->input->post('message',TRUE),$this->input->post('message_type',TRUE)),
				'org_id'=>$this->search_type($this->input->post('org_id',TRUE),$this->input->post('org_id_type',TRUE)),
			);
			$end_date = $this->input->post('end_date',TRUE);
			$start_date = $this->input->post('start_date',TRUE);
			$date_array = array($end_date, $start_date);
			$date_warning_message = $this->get_date_filter_validation_message($date_array);
			
			$between = array(
				'login_time' => $this->check_date($start_date,$end_date)
			);
			$typesearch = array (
				'org_id' => array(
					'typesql' => '',
					'name' => $this->search_type($this->input->post('username',TRUE),$this->input->post('username_type',TRUE)),
					'type' => 5
				)
			);
			//get direction and if exported
			$dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
			$export = $this->input->post('export',TRUE);
			$export_pdf = $this->input->post('export_pdf',TRUE);
			$print_page = $this->input->post('print_page',TRUE);
			$is_export = 0;
			if($export) {
				$is_export = 'excel';
			}
			else if($export_pdf) {
				$is_export = 'pdf';
			}
			else if($print_page) {
				$is_export = 'print';
			}
			$data['is_export'] = $is_export;
			
			//get data
			$response = $this->reports_helper('login',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$items_per_page);
			$event_list = $response['response'];
			$form_data = $this->input->post(NULL,TRUE);
			$form_data['direction'] = $dir;
			$form_data['cur_page'] = $destination_page;
			$form_data['date_warning_message'] = $date_warning_message;
			$size = $response['size'];
			if ($selector['success']==1) $selected='Success: True';
			elseif ($selector['success']!='(ALL)') $selected='Success: False';
			//ExportPDF-PRINT
			$response_export = $this->reports_helper('login',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$size);
			$response_export_list = $response_export['response'];
			$data['filters'] = $this->export_info($items,$between,$selected,null);
		}
		else { //if this is the first time you have loaded the page (ie no filters have fields)
			$event_list = $this->loginsmodel->get_first_logins($items_per_page)->result();
			//set defaults
			$form_data = array(
			 'direction' => 'DESC',
			 'order' => 'login_time',
			 'cur_page' => '1'
			);
			//get number of items in log
			$size = $this->loginsmodel->get_size()->result();
			$size = $size[0]->count;
			$export = FALSE;
			$export_pdf = FALSE;
			$print_page = FALSE;
		}
		//set options for comparing
		$data['compare'] = array(
			'equals' => 'Equals',
			'contains' => 'Contains',
			'starts' => 'Starts With',
			'ends' => 'Ends With',
		);
		
		//pagination setup
		$pages->items_total = $size;
		$pages->current_page = $destination_page;
		$pages->paginate();
		$form_data['pagination_bar'] = $pages->display_pages();
		$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
		
		//gets image for asc or desc
		if($form_data['direction'] == 'DESC'){
			$data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
		}
		else{
			$data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>';
		}
		
		$form_data['num_pages'] = ceil($size/$items_per_page); //num of log pages
		$form_data['items_per_page'] = $items_per_page;
		$form_data['pages'] = $pages;
		$data['form_data'] = $form_data;
		$data['event_list'] = $event_list;
		//converts application's numbers into their names
		foreach($event_list as $event) {
			//convert org id to username
			$event->user_id=$this->usersmodel->get_username_from_org_id($event->org_id);
			//get binary true/false into text
			if($event->success === 1) { $event->success = 'TRUE'; }
			else { $event->success = 'FALSE'; }
			//convert data into readable formant.
			$event->login_time = date('m/d/y h:i:s A',$event->login_time);
			
		}
		//if export
		if($export){
		$this->export(array('ID','Session ID','IP Address','Date ('.$data['timezone_abbr'].')','Success','Message','Org ID','Username'),$event_list,'logins_log',$items,$between,$selected,null);
		}else if($export_pdf) {
			if (!empty($response_export)){
				$data['event_list'] = $response_export_list;
			} else {
				$data['event_list'] = $event_list;
			}
			foreach($data['event_list'] as $event) {
				//convert org id to username
				$event->user_id=$this->usersmodel->get_username_from_org_id($event->org_id);
				//get binary true/false into text
				if($event->success === 1) { $event->success = 'TRUE'; }
				else { $event->success = 'FALSE'; }
				//convert data into readable formant.
				$event->login_time = date('m/d/y h:i:s A',$event->login_time);
			}
			$report_content = $this->input->post('report_content',TRUE);
			$html = $this->load->view('api/reports/result_tables/result_logins', $data, true);
			$this->export_pdf('Logins Report.pdf', $html);
		}else if($print_page) {
			$this->clear_cache();
			if (!empty($response_export)){
				$data['event_list'] = $response_export_list;
			} else {
				$data['event_list'] = $event_list;
			}
			foreach($data['event_list'] as $event) {
				//convert org id to username
				$event->user_id=$this->usersmodel->get_username_from_org_id($event->org_id);
				//get binary true/false into text
				if($event->success === 1) { $event->success = 'TRUE'; }
				else { $event->success = 'FALSE'; }
				//convert data into readable formant.
				$event->login_time = date('m/d/y h:i:s A',$event->login_time);
			}
			$data['print_page'] = true;
			$this->load->view('api/reports/result_tables/result_logins', $data);
		}else{
			$this->load->view('api/reports/logins', $data);
		}
	}
	
	//function for mail report
	public function report_mail(){
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
		
		$data['title'] = 'Direct API: Reports';
		$data['active_tab'] = array('reports'=>true);
		$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
		$data['tabs'] = $this->create_tabs("mail_report");
		//get user id from session to get permissions
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['time'] = date('m/d/Y h:i:s A', time());
		$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
		$response_list = $response_export_list = array();
		$selected = array();
		
		if(!$data['show']['reports']) { show_error('Forbidden',403); }
		$successful = $this->input->post('sender_type',TRUE);//gets selected 
		if($successful){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
			//adds each component type into its own json
			$selector = array(
				'success' =>  $this->input->post('successful',TRUE),
				'mdn' =>  $this->input->post('mdn',TRUE),
				'inbound_outbound' => $this->input->post('bound',TRUE),
			);
			
			$items = array(
				'id' => $this->search_type($this->input->post('id',TRUE),$this->input->post('id_type',TRUE)),
				'size'=>$this->search_type($this->input->post('file_size',TRUE),$this->input->post('file_size_type',TRUE)),
				'attachment_types'=>$this->search_type($this->input->post('attachment_type',TRUE),$this->input->post('attachment_type_type',TRUE)),
				'sender'=>$this->search_type($this->input->post('sender',TRUE),$this->input->post('sender_type',TRUE)),
				'recipient'=>$this->search_type($this->input->post('recipient',TRUE),$this->input->post('recipient_type',TRUE)),
			);
			$end_date = $this->input->post('end_date',TRUE);
			$start_date = $this->input->post('start_date',TRUE);
			$date_array = array($end_date, $start_date);
			$date_warning_message = $this->get_date_filter_validation_message($date_array);
			
			$between = array(
				'time' => $this->check_date($start_date,$end_date)
			);
			$typesearch = array (
			);
			
			$export = $this->input->post('export',TRUE);
			$export_pdf = $this->input->post('export_pdf',TRUE);
			$print_page = $this->input->post('print_page',TRUE);
			$is_export = 0;
			if($export) { $is_export = 'excel'; }
			else if($export_pdf) { $is_export = 'pdf'; }
			else if($print_page) { $is_export = 'print'; }
			$data['is_export'] = $is_export;
			
			$dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
			$export = $this->input->post('export',TRUE);
			$response = $this->reports_helper('mail',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$items_per_page);
			$event_list = $response['response'];
			$form_data = $this->input->post(NULL,TRUE);
			$form_data['direction'] = $dir;
			$form_data['cur_page'] = $destination_page;
			$form_data['date_warning_message'] = $date_warning_message;
			$size = $response['size'];
			if($selector['success'] == 1) { array_push($selected, 'Success: True'); }
			else if($selector['success'] == '(ALL)') { array_push($selected, null); }
			else { array_push($selected, 'Success: False'); }
			if($selector['mdn'] == 1) { array_push($selected, 'MDN: True'); }
			else if($selector['mdn'] == '(ALL)') { array_push($selected, null); }
			else { array_push($selected, 'MDN: False'); }
			if($selector['inbound_outbound'] == 1) { array_push($selected, 'Direction: Inbound'); }
			else if($selector['inbound_outbound'] == '(ALL)') { array_push($selected, null); }
			else { array_push($selected, 'Direction: Outbound'); }
			$response_export = $this->reports_helper('mail',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$size);
			$response_export_list = $response_export['response'];
			$data['filters'] = $this->export_info($items,$between,$selected,null);
		}
		else{//if this is the first time you have loaded the page (ie no filters have fields)
			$event_list = $this->mailmodel->get_first_mail($items_per_page)->result();
			//set defaults
			$form_data = array(
			 'direction' =>'DESC',
			 'order'=>'time',
			 'cur_page'=>'1',
			 'bound'=>'(ALL)',
			 'success'=>'(ALL)',
			);
			//get number of items in log
			$size = $this->mailmodel->get_size()->result();
			$size = $size[0]->count;
			$export = FALSE;
			$export_pdf = FALSE;
			$print_page = FALSE;
		}
		//set options for comparing
		$data['compare'] = array(
			'equals' => 'Equals',
			'contains' => 'Contains',
			'starts' => 'Starts With',
			'ends' => 'Ends With'
		);
		
		//pagination setup
		$pages->items_total = $size;
		$pages->current_page = $destination_page;
		$pages->paginate();
		$form_data['pagination_bar'] = $pages->display_pages();
		$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
		
		//gets image for asc or desc
		if($form_data['direction'] == 'DESC'){
			$data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
		}
		else{
			$data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
		}
		
		$form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
		$form_data['items_per_page'] = $items_per_page;
		$form_data['pages'] = $pages;
		$data['form_data'] = $form_data;
		$data['event_list'] = $event_list;
		
		//converts application's numbers into their names
		$lists = array($event_list, $response_export_list);
		foreach($lists as $list) {
			if(isset($list)) {
				foreach($list as $event) {
					//get the recipients and convert to array
					$event->recipient=json_decode($event->recipient);
					$recip = '';
					if(isset($event->recipient)){
						foreach($event->recipient as $key =>$value){
							//for all items after the first
							if($key > 0) {
								//if export make them comma separated 
								if($export) { $recip .= ', '; }
								//else when in view make each email on a line
								else { $recip.= '<br/>'; }
							}
							$recip .= $value; //add email
						}
					}
					$event->recipient = $recip;
					
					//binary true/false into text
					if($event->success) { $event->success = 'TRUE'; }
					else { $event->success = 'FALSE'; }
					
					//binary mdn into text
					if($event->mdn) { $event->mdn = 'TRUE'; }
					else { $event->mdn = 'FALSE'; }
					
					//binary inbound/outbound into text
					if($event->inbound_outbound){ $event->inbound_outbound = 'Inbound'; }
					else { $event->inbound_outbound = 'Outbound'; }
					
					//time in readable format
					$event->time = date("m/d/y h:i:s A",$event->time);
				}
			}
		}
		if($export){
			$this->export(array('ID','Date ('.$data['timezone_abbr'].')','Size(KB)','Sender','Recipient','Attachment Type','Success','Direction'),$event_list,'mail_log',$items,$between,$selected,null);
		} 
		else if($export_pdf){
			if (!empty($response_export)){ $data['event_list'] = $response_export_list; } 
			else { $data['event_list'] = $event_list; }
			$report_content = $this->input->post('report_content',FALSE);
			$html = $this->load->view('api/reports/result_tables/result_mail', $data, true);
			$this->export_pdf('Mail Report.pdf', $html);
		} 
		else if($print_page) {
			$this->clear_cache();
			if (!empty($response_export)){ $data['event_list'] = $response_export_list; }
			else { $data['event_list'] = $event_list; }
			$data['print_page'] = true;
			$this->load->view('api/reports/result_tables/result_mail', $data);
		}
		else {
			$this->load->view('api/reports/mail', $data);
		}

	}

	
	//function for facility report
	public function report_facility(){
		//page set up
		$all_report = FALSE;
		if($this->has_access("facility_report_all")){
			$all_report = TRUE;
			$facility_id = null;
		}else{
			$mailbox = Mailbox::find_one(array("name"=>$this->user->username));
			$facility_id = $mailbox->facility_id;
		}
		$data['all_report'] = $all_report;
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
		$selected = null;
	
		$data['title'] = 'Direct API: Reports';
		$data['active_tab'] = array('reports'=>true);
		$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
		$data['tabs'] = $this->create_tabs("facility_report");
		$data['time'] = date('m/d/Y h:i:s A', time());
		$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
	
		if(!$data['show']['reports']) {
			show_error('Forbidden',403);
		}
	
		$is_active = null;
		//gets selected facility
		$facility_selected = $this->input->post('whichfacility',TRUE);
		if(!$all_report){
			$facility_selected = $facility_id;
		}
		//checks to see if there is an facility selected.  This shows whether or not this is the first time the page has loaded.
		if($facility_selected || !$all_report){
			$selector = array(
					'F.id' => ($facility_selected),
			);
	
			//POST information
			$items = array();
			$end_date = $this->input->post('end_date',TRUE);
			$start_date = $this->input->post('start_date',TRUE);
			$date_array = array($end_date, $start_date);
			$date_warning_message = $this->get_date_filter_validation_message($date_array);
			
			//Setting exports
			$export = $this->input->post('export',TRUE);
			$export_pdf = $this->input->post('export_pdf',TRUE);
			$print_page = $this->input->post('print_page',TRUE);
			$is_export = false;
			if($export || $export_pdf || $print_page) {
				$is_export = true;
			}
			$data['is_export'] = $is_export;
	
			$between = array(
					'ms.timestamp' => $this->check_date($start_date,$end_date),
			);
			//get direction (desc/asc)and if it is being exported
			$order = ($this->input->post('order',TRUE))?$this->input->post('order',TRUE):'name';
			$dir = $this->direction_check($order,$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
	
			//calls helper to get data
			$response = $this->reports_helper('facility',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
			$facility_list = $response['response'];
			//ExportPDF-PRINT
			$response_export = $this->reports_helper('facility',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
			$response_export_list = $response_export['response'];
	
			//set form data
			$form_data = $this->input->post(NULL,TRUE);
			$form_data['direction'] = $dir;
			$form_data['order'] = $order;
			$form_data['cur_page'] = $destination_page;
			$form_data['date_warning_message'] = $date_warning_message;
			$size = $response['size'];
	
			//gets image for asc or desc
			if($form_data['direction'] == 'DESC'){
				$data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
			}
			else{
				$data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
			}
	
			//set form data and send form_data
			$form_data['items_per_page'] = $items_per_page;
			$data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
			$form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
			$form_data['pages'] = $pages;
			$data['form_data'] = $form_data;
			$data['facility_list'] = $facility_list;
	
			//pagination setup
			$pages->items_total = $size;
			$pages->current_page = $destination_page;
			$pages->paginate();
			if(!$all_report){
				if($facility_id){
					foreach($data['facilities'] as $facility){
						if($facility->id === $facility_id){
							$data['facility'] = $facility->name;
						}
					}
				}else{
					$data['facility'] = "No facility set";
				}
			}
			if($selector['F.id'] != '(ALL)') $selected = 'Facility: ' . $this->facilitymodel->get_facility($selector['F.id'])->result()[0]->name;
			//ExportPDF-PRINT
			$response_export = $this->reports_helper('facility',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$size);
			$response_export_list = $response_export['response'];
			//Getting_totals
			$size_all = $this->facilitymodel->get_facility_list_size_reports()->result();
			$response_total = $this->reports_helper('facility',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$size_all[0]->count);
			$facility_list_totals = $response_total['response'];
			$data['filters'] = $this->export_info($items,$between,$selected,null);
		} else {
			$data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
			$facility_list = $this->facilitymodel->get_first_facilities($items_per_page)->result();
			$size = $this->facilitymodel->get_facility_list_size_reports()->result();
			$size = $size[0]->count;
			$export = FALSE;
			$form_data = array(
					'direction' => 'ASC',
					'order' => 'name',
					'cur_page' => '1',
			);
			$data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
			//pagination setup
			$pages->items_total = $size;
			$pages->current_page = $destination_page;
			$pages->paginate();
			$form_data['pagination_bar'] = $pages->display_pages();
			$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
			$form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
			$form_data['items_per_page'] = $items_per_page;
			$form_data['pages'] = $pages;
			$data['form_data'] = $form_data;
			$data['facility_list'] = $facility_list;
			//Settings Exports
			$export = FALSE;
			$export_pdf = FALSE;
			$print_page = FALSE;
			//Getting app Totals
			$facility_list_totals = $this->facilitymodel->get_first_facilities($size)->result();
		}
	
	//Set view or export view
		if($export){
		//Setting Totals for Excel Export
		$totalCount = count((array)$facility_list);
		//Unset Row Number for Export $totalCount = count((array)$facility_list);
		for ($i = 0; $i < $totalCount; $i++) {
			unset($facility_list[$i]->row);
			unset($facility_list[$i]->id);
		}
		$facility_list[$totalCount] = new StdClass;
		$facility_list[$totalCount]->name = 'VA Total:';
		$facility_list[$totalCount]->Number_of_users = $this->sum_by_object_name((array)$facility_list, 'Number_of_users');
		$facility_list[$totalCount]->Number_in_group = $this->sum_by_object_name((array)$facility_list, 'Number_in_group');
		$facility_list[$totalCount]->Number_of_sent = $this->sum_by_object_name((array)$facility_list, 'Number_of_sent');
		$facility_list[$totalCount]->Number_of_seen = $this->sum_by_object_name((array)$facility_list, 'Number_of_seen');
		$facility_list[$totalCount]->Total_messages = $this->sum_by_object_name((array)$facility_list, 'Total_messages');
		$this->export(array('VA Facility','Number of Users','Number of Groups', 'Total Messages Sent','Total Messages Received','Total Messages'),$facility_list,'facility_report',$items,$between,$selected,null);
		} else if($export_pdf) {
			if (!empty($response_export)){
				$data['facility_list'] = $response_export_list;
			} else {
				$data['facility_list'] = $responses_list;
			}
			$html = $this->load->view('api/reports/result_tables/result_facility', $data, true);
			$this->export_pdf('Facility Summary Report.pdf', $html);
		} else if($print_page) {
			$this->clear_cache();
			if (!empty($response_export)){
				$data['facility_list'] = $response_export_list;
			} else {
				$data['facility_list'] = $responses_list;
			}
			$data['print_page'] = true;
			$this->load->view('api/reports/result_tables/result_facility', $data);
		}else{
			$data['facility_list_totals'] = $facility_list_totals;
			$this->load->view('api/reports/facility', $data);
		}
	}
	
	//function for hisp report
	public function report_hisp(){
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
	
		$data['title'] = 'Direct API: Reports';
		$data['active_tab'] = array('reports'=>true);
		$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
		$data['tabs'] = $this->create_tabs("hisp_report");
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['time'] = date('m/d/Y h:i:s A', time());
		$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
		$selected = null;
	
		if(!$data['show']['reports']) {
			show_error('Forbidden',403);
		}
		$application_id = $this->input->post('application_id',TRUE);//gets selected
		$data['domain_app_id_maps'] = $this->hispmodel->get_domain_app_id_maps();
		if($application_id){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
			//adds each component type into its own json
			$items = array();
			$end_date = $this->input->post('end_date',TRUE);
			$start_date = $this->input->post('start_date',TRUE);
			$date_array = array($end_date, $start_date);
			$date_warning_message = $this->get_date_filter_validation_message($date_array);
	
			$between = array(
					'time' => $this->check_date($start_date,$end_date)
			);
			$order = $this->input->post('order',TRUE);
			$dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
			$export = $this->input->post('export',TRUE);
			$export_pdf = $this->input->post('export_pdf',TRUE);
			$print_page = $this->input->post('print_page',TRUE);
			$is_export = 0;
			if($export) {
				$is_export = 'excel';
			}
			else if($export_pdf) {
				$is_export = 'pdf';
			}
			else if($print_page) {
				$is_export = 'print';
			}
			if ($application_id!='(ALL)') $selected = 'HISP: ' . $this->hispmodel->get_domain_by_application_id($application_id);
			$data['is_export'] = $is_export;
			$message_counts = $this->hispmodel->get_message_counts_grouped_by_domain($application_id, $between, $order, $dir, $destination_page, $items_per_page, $is_export);
			
			$size = $message_counts['total_size'];
			//getting app totals
			$message_counts_totals = $this->hispmodel->get_message_counts_grouped_by_domain($application_id, $between, $order, $dir, $destination_page, $size, $is_export);
			
			$form_data = $this->input->post(NULL,TRUE);
			$form_data['direction'] = $dir;
			$form_data['cur_page'] = $destination_page;
			$form_data['date_warning_message'] = $date_warning_message;
			$data['filters'] = $this->export_info($items,$between,$selected,null);
		}
		else {	//if this is the first time you have loaded the page (ie no filters have fields)
			$message_counts = $this->hispmodel->get_message_counts_grouped_by_domain($application_id, null, null, null, $destination_page, $items_per_page, false);
			//set defaults
			$form_data = array(
					'direction' =>'ASC',
					'order'=>'domain_name',
					'cur_page'=>'1',
			);
			$export = FALSE;
			$export_pdf = FALSE;
			$print_page = FALSE;
			
			$size = $message_counts['total_size'];
			//getting app totals
			$message_counts_totals = $this->hispmodel->get_message_counts_grouped_by_domain($application_id, null, null, null, 1, $size, false);
		}
		
		//set options for available applications
		$data['apps'] = $this->applicationmodel->get_applications()->result();
	
		//pagination setup
		$pages->items_total = $size;
		$pages->current_page = $destination_page;
		$pages->paginate();
		$form_data['pagination_bar'] = $pages->display_pages();
		$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
	
		//gets image for asc or desc
		if($form_data['direction'] == 'DESC'){
			$data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
		}
		else{
			$data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
		}
	
		$form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
		$form_data['items_per_page'] = $items_per_page;
		$form_data['pages'] = $pages;
		$data['form_data'] = $form_data;
		$data['message_counts'] = $message_counts['list'];
	
		if($export){
			$this->export(array('Domain Name','Total Messages Sent', 'Total Messages Received','Total Messages'),$message_counts['list'],'hisp',$items,$between,$selected,null);
		}
		else if($export_pdf) {
			$report_content = $this->input->post('report_content',TRUE);
			$html = $this->load->view('api/reports/result_tables/result_hisp', $data, true);
			$this->export_pdf('HISP Summary Report.pdf', $html);
		}
		else if($print_page) {
			$this->clear_cache();
			$data['print_page'] = true;
			$this->load->view('api/reports/result_tables/result_hisp', $data);
		}
		else{
			$data['message_counts_totals'] = $message_counts_totals;
			$this->load->view('api/reports/hisp', $data);
		}
	}
	
	//function for points of origin report
	public function report_points_of_origin(){
		
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
	
		$data['title'] = 'Direct API: Reports';
		$data['active_tab'] = array('reports'=>true);
		$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
		$data['tabs'] = $this->create_tabs("points_of_origin_report");
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['time'] = date('m/d/Y h:i:s A', time());
		$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
		$selected = null;
		
		if(!$data['show']['reports']) {
			show_error('Forbidden',403);
		}
		$application_id = $this->input->post('application_id',TRUE);//gets selected
		
		if($application_id){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
			//adds each component type into its own json
			$end_date = $this->input->post('end_date',TRUE);
			$start_date = $this->input->post('start_date',TRUE);
			$date_array = array($end_date, $start_date);
			$date_warning_message = $this->get_date_filter_validation_message($date_array);
				
			$between = array(
					'call_date' => $this->check_date($start_date,$end_date)
			);
			
			$order = $this->input->post('order',TRUE);
			$dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
			$export = $this->input->post('export',TRUE);
			$export_pdf = $this->input->post('export_pdf',TRUE);
			$print_page = $this->input->post('print_page',TRUE);
			$is_export = false;
			if($export || $export_pdf || $print_page) {
				$is_export = true;
			}
			if ($application_id!='(ALL)') $selected = 'Application: ' . $this->applicationmodel->get_application_name_by_id($application_id)->result()[0]->name;
			$data['is_export'] = $is_export;
			$message_counts = $this->pointsoforiginmodel->get_message_counts_grouped_by_application($application_id, $between, $order, $dir, $destination_page, $items_per_page, $is_export);
			$form_data = $this->input->post(NULL,TRUE);
			$form_data['direction'] = $dir;
			$form_data['cur_page'] = $destination_page;
			$form_data['date_warning_message'] = $date_warning_message;
			$data['filters'] = $this->export_info(null,$between,$selected,null);
		}
		else{//if this is the first time you have loaded the page (ie no filters have fields)
			$message_counts = $this->pointsoforiginmodel->get_message_counts_grouped_by_application($application_id, null, null, null, $destination_page, $items_per_page, false);
			//set defaults
			$form_data = array(
				 'direction' =>'ASC',
				 'order'=>'application_name',
				 'cur_page'=>'1',
			);
			$export = FALSE;
			$export_pdf = FALSE;
			$print_page = FALSE;
		}
		$size = $message_counts['total_size'];
		
		//set options for available applications
		$data['apps'] = $this->applicationmodel->get_applications()->result();
	
		//pagination setup
		$pages->items_total = $size;
		$pages->current_page = $destination_page;
		$pages->paginate();
		$form_data['pagination_bar'] = $pages->display_pages();
		$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
	
		//gets image for asc or desc
		if($form_data['direction'] == 'DESC'){
			$data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
		}
		else{
			$data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
		}
	
		$form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
		$form_data['items_per_page'] = $items_per_page;
		$form_data['pages'] = $pages;
		$data['form_data'] = $form_data;
		$data['message_counts'] = $message_counts['list'];
		
		if($export){
			$this->export(array('Originating Application','Total Messages Sent'),$message_counts['list'],'points_of_origin',null,$between,$selected,null);
		}
		else if($export_pdf) {
			$html = $this->load->view('api/reports/result_tables/result_points_of_origin', $data, true);
			$this->export_pdf('Points of Origin Report.pdf', $html);
		}
		else if($print_page) {
			$this->clear_cache();
			$data['print_page'] = true;
			$this->load->view('api/reports/result_tables/result_points_of_origin', $data);
		}
		else{
			$this->load->view('api/reports/points_of_origin', $data);
		}
	}
	
	//function for User Activity Summary
	public function report_user_activity_summary(){
		//page set up
		$all_report = FALSE;
		if($this->has_access('user_activity_summary_report_all')){
			$all_report = TRUE;
			$facility_id = null;
		}
		else {
			$mailbox = Mailbox::find_one(array('name'=>$this->user->username));
			$facility_id = $mailbox->facility_id;
		}
		$data['all_report'] = $all_report;
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
		$selected = null;
		
		//Declaring Summary Array
		$SummaryListing =  array();
		
		$data['title'] = 'Direct API: Reports';
		$data['active_tab'] = array('reports'=>true);
		$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
		$data['tabs'] = $this->create_tabs("user_activity_summary_report");
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		if(!$data['show']['reports']) {
			show_error('Forbidden',403);
		}
		$data['time'] = date('m/d/Y h:i:s A', time());
		$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
		$is_active = null;
		//gets selected facility
		$facility_selected = $this->input->post('whichfacility',TRUE);
		if(!$all_report){
			$facility_selected = $facility_id;
		}
		//checks to see if there is an facility selected.  This shows whether or not this is the first time the page has loaded.
		if($facility_selected || !$all_report){
			$selector = array(
					'F.id' => ($facility_selected),
			);
			//POST information
			$is_user_active = $this->input->post('user_status_type',TRUE);
			if($is_user_active == "(ALL)"){
				$items = array(
					'U.username' => $this->search_type($this->input->post('txtUserName',TRUE),$this->input->post('userName_type',TRUE)),
					'user_ext_mail' => $this->search_type($this->input->post('txtVAEmailAddress',TRUE),$this->input->post('va_email_type',TRUE)),
				);
			} else {
				$items = array(
					'U.username' => $this->search_type($this->input->post('txtUserName',TRUE),$this->input->post('userName_type',TRUE)),
					'user_ext_mail' => $this->search_type($this->input->post('txtVAEmailAddress',TRUE),$this->input->post('va_email_type',TRUE)),
					'is_active' => $this->input->post('user_status_type',TRUE),
				);
			}
			//set options for comparing
			$data['compare'] = array(
					'equals' => 'Equals',
					'contains' => 'Contains',
					'starts' => 'Starts With',
					'ends' => 'Ends With'
			);	
			$end_date = $this->input->post('end_date',TRUE);
			$start_date = $this->input->post('start_date',TRUE);
			$date_array = array($end_date, $start_date);
			$date_warning_message = $this->get_date_filter_validation_message($date_array);
			//Setting exports
			$export = $this->input->post('export',TRUE);
			$export_pdf = $this->input->post('export_pdf',TRUE);
			$print_page = $this->input->post('print_page',TRUE);
			$is_export = false;
			if($export || $export_pdf || $print_page) {
				$is_export = true;
			}
			$data['is_export'] = $is_export;
	
			$between = array(
				'ms.timestamp' => $this->check_date($start_date,$end_date),
			);
			//get direction (desc/asc)and if it is being exported
			$order = ($this->input->post('order',TRUE))?$this->input->post('order',TRUE):'facilityName';
			$dir = $this->direction_check($order,$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
			//calls helper to get data
			$response = $this->reports_helper('user_activity_summary',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
			$size = $response['size'];
			$users_facility_list = $response['response'];
			$counter = 0;
			//merge arrays
			foreach ($users_facility_list as $userInfo){
				//print_r($userInfo);
				
				$userUsername = $userInfo->Username;
				$userID = $userInfo->id;
				$userFacilityName = $userInfo->Name;				
				$userNumber_of_sent = $userInfo->Number_of_sent;
				$userNumber_of_seen = $userInfo->Number_of_seen;
				$userTotal_of_messages = $userInfo->Total_messages;
				$user_ext_mail = $userInfo->user_ext_mail;
				$userRow = $userInfo->row;
				$userIsActive = $userInfo->is_active;
				//Get LDAP Information
				$resultArray = $this->useractivitysummarymodel->get_ldap_request($userInfo->Username);
				
				//checking that LDAP Results are not null
				if (isset ($resultArray[0]['givenname'][0])){
					$userGivenname = $resultArray[0]['givenname'][0];
				}
				else{ $userGivenname = ''; }
				
				if (isset ($resultArray[0]['sn'][0])){
					$userSN = $resultArray[0]['sn'][0];
				}
				else{ $userSN = ''; }
				
				if (isset ($resultArray[0]['mail'][0])){
					$userMail = $resultArray[0]['mail'][0];
				}
				else{ $userMail = ''; }
			
				if($userIsActive == 1){
					$userActiveText = 'Active';
				} else {
					$userActiveText = 'Inactive';
				}
				$SummaryListingObjects = new stdClass;
				$SummaryListingObjects -> userSN = $userSN;
				$SummaryListingObjects -> userGivenname = $userGivenname;					
				$SummaryListingObjects -> username = $userUsername;
				$SummaryListingObjects -> userMail = $userMail;
				$SummaryListingObjects -> facilityName = $userFacilityName;
				$SummaryListingObjects -> userStatus = $userActiveText;
				$SummaryListingObjects -> user_ext_mail = $user_ext_mail;
				$SummaryListingObjects -> userNumber_of_sent = $userNumber_of_sent;
				$SummaryListingObjects -> userNumber_of_seen = $userNumber_of_seen;			
				$SummaryListingObjects -> userTotal_of_messages = $userTotal_of_messages;
				array_push($SummaryListing, $SummaryListingObjects);
				
			}
			//set form data
			$form_data = $this->input->post(NULL,TRUE);		
			$form_data['direction'] = $dir;
			$form_data['cur_page'] = $destination_page;
			$form_data['date_warning_message'] = $date_warning_message;
			$form_data['order'] = $order;
			
			//gets image for asc or desc
			if($form_data['direction'] == 'DESC'){
				$data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
			}else{
				$data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
			}
			//set form data and send form_data
			$form_data['items_per_page'] = $items_per_page;
			$data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
			$form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
			$form_data['pages'] = $pages;
			$data['form_data'] = $form_data;

			//Sorting Array 
			$ldapfilters = array();
			//Converting to array for sorting
			$newArray = $this->object_to_array($SummaryListing);
			//filter_sn
			$sn_filter = $this->input->post('txtSN',TRUE);
			if($sn_filter != ""){
				$sn_filter_type = $this->input->post('last_name_type',TRUE);
				array_push($ldapfilters, 'Last Name ' . strtolower($data['compare'][$sn_filter_type]). ': ' . $sn_filter);
				//setting filter type
				$search_sn = $this->search_type_for_array($sn_filter,$sn_filter_type);
				//Search on array for true values
				$newArray = $this->array_multi_search_filter($newArray, 'userSN', $search_sn);
			}
			//filter_given_name
			$givenname_filter = $this->input->post('txtGivenname',TRUE);
			if($givenname_filter != ""){
				$givenname_filter_type = $this->input->post('first_name_type',TRUE);
				array_push($ldapfilters, 'First Name ' . strtolower($data['compare'][$givenname_filter_type]). ': ' . $givenname_filter);
				//setting filter type
				$search_givenname = $this->search_type_for_array($givenname_filter,$givenname_filter_type);
				//Search on array for true values
				$newArray = $this->array_multi_search_filter($newArray, 'userGivenname', $search_givenname);
			}
			//filter_va_address
			$direct_address_filter = $this->input->post('txtDirectAddress',TRUE);
			if($direct_address_filter != ""){
				$direct_address_filter_type = $this->input->post('direct_address_type',TRUE);
				array_push($ldapfilters, 'Direct Address ' . strtolower($data['compare'][$direct_address_filter_type]). ': ' . $direct_address_filter);
				//setting filter type
				$search_direct_address = $this->search_type_for_array($direct_address_filter,$direct_address_filter_type);	
				//Search on array for true values
				$newArray = $this->array_multi_search_filter($newArray, 'userMail', $search_direct_address);	
			}								
			//Sorting array 
			$this->sortBy($order, $newArray, $dir);
			$SummaryListingExport = new stdClass;
			$SummaryListingExport = $this->array_to_object($SummaryListing);
			
			unset($SummaryListing);
			$SummaryListing = $this->array_to_object(array_slice($newArray, ($destination_page-1)*ITEMS_PER_PAGE_DEFAULT, $items_per_page));
			$data['summary_list'] = $SummaryListing;
			
			$SummaryListingExport_2 = new stdClass;
			$SummaryListing_2 = $this->array_to_object(array_slice($newArray, ($destination_page-1)*ITEMS_PER_PAGE_DEFAULT, $size));
			$SummaryListingExport_2 = $this->array_to_object($SummaryListing_2);
			
			$summary_listing_totals = new stdClass;
			$summary_listing_totals_array = $this->array_to_object(array_slice($newArray, (1-1)*ITEMS_PER_PAGE_DEFAULT, $size));
			$summary_listing_totals = $this->array_to_object($summary_listing_totals_array);

			if($selector['F.id'] != '(ALL)') $selected = 'Facility: ' . $this->facilitymodel->get_facility($selector['F.id'])->result()[0]->name;
			//pagination setup
			$pages->items_total = sizeof($newArray);;
			$pages->current_page = $destination_page;
			$pages->paginate();
			if(!$all_report){
				if($facility_id){
					foreach($data['facilities'] as $facility){
						if($facility->id === $facility_id){
							$data['facility'] = $facility->name;
						}
					}
				}
				else { $data['facility'] = 'No facility set'; }
			}
			$data['filters'] = $this->export_info($items,$between,$selected,$ldapfilters);
		} else {
			$data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
			
			$users_facility_list = $this->useractivitysummarymodel->get_first_user_activities($items_per_page)->result();
			foreach ($users_facility_list as $userInfo){
				//print_r($userInfo);
				$userUsername = $userInfo->Username;
				$userID = $userInfo->id;
				$userFacilityName = $userInfo->Name;				
				$userNumber_of_sent = $userInfo->Number_of_sent;
				$userNumber_of_seen = $userInfo->Number_of_seen;
				$userTotal_of_messages = $userInfo->Total_messages;
				$userRow = $userInfo->row;
				$userIsActive = $userInfo->is_active;
				$user_ext_mail = $userInfo->user_ext_mail;
				//Get LDAP Information
				$resultArray = $this->useractivitysummarymodel->get_ldap_request($userInfo->Username);
				//checking that LDAP Results are not null
				if (isset ($resultArray[0]['givenname'][0])){
					$userGivenname = $resultArray[0]['givenname'][0];
				}
				else { $userGivenname = '';}
				
				if (isset ($resultArray[0]['sn'][0])){
					$userSN = $resultArray[0]['sn'][0];
				}
				else { $userSN = ''; }
				
				if (isset ($resultArray[0]['mail'][0])){
					$userMail = $resultArray[0]['mail'][0];
				}
				else { $userMail = ''; }
				
				if($userIsActive == 1){ $userActiveText = 'Active'; }
				else { $userActiveText = 'Inactive'; }
				
				$SummaryListingObjects = new stdClass;
				$SummaryListingObjects -> userSN = $userSN;
				$SummaryListingObjects -> userGivenname = $userGivenname;					
				$SummaryListingObjects -> username = $userUsername;
				$SummaryListingObjects -> userMail = $userMail;
				$SummaryListingObjects -> facilityName = $userFacilityName;
				$SummaryListingObjects -> user_ext_mail = $user_ext_mail;
				$SummaryListingObjects -> userStatus = $userActiveText;
				$SummaryListingObjects -> userNumber_of_sent = $userNumber_of_sent;
				$SummaryListingObjects -> userNumber_of_seen = $userNumber_of_seen;			
				$SummaryListingObjects -> userTotal_of_messages = $userTotal_of_messages;
				
				array_push($SummaryListing, $SummaryListingObjects);
			
			}
			
			$size = $this->useractivitysummarymodel->get_first_user_activities_list_size()->result();
			$size = $size[0]->count;
			$form_data = array(
					'direction' => 'DESC',
					'order' => 'facilityName',
					'cur_page' => '1',
			);
			//set options for comparing
				$data['compare'] = array(
						'equals' => 'Equals',
						'contains' => 'Contains',
						'starts' => 'Starts With',
						'ends' => 'Ends With'
				);
			//pagination setup
			$pages->items_total = $size;
			$pages->current_page = $destination_page;
			$pages->paginate();
			$form_data['pagination_bar'] = $pages->display_pages();
			$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
			$form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
			$form_data['items_per_page'] = $items_per_page;
			$form_data['pages'] = $pages;
			$data['form_data'] = $form_data;
			$data['summary_list'] = $SummaryListing;
			$data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
			//Export Settings
			$export = FALSE;
			$export_pdf = FALSE;
			$print_page = FALSE;
			//Adding VA Totals
			$users_facility_list_totals = $this->useractivitysummarymodel->get_first_user_activities($pages->items_total)->result();
			$summary_listing_totals = array();
			
			foreach ($users_facility_list_totals as $user_info_total){
				$user_number_of_sent = $user_info_total->Number_of_sent;
				$user_number_of_seen = $user_info_total->Number_of_seen;
				$user_total_of_messages = $user_info_total->Total_messages;
				$summary_listing_objects_totals = new stdClass;
				//Adding to Original Array
				$summary_listing_objects_totals -> userNumber_of_sent = $user_number_of_sent;
				$summary_listing_objects_totals -> userNumber_of_seen = $user_number_of_seen;			
				$summary_listing_objects_totals -> userTotal_of_messages = $user_total_of_messages;
				array_push($summary_listing_totals, $summary_listing_objects_totals);
			}
			//Adding to SummaryListing_Totals
			$new_summary_array = array();
			$new_summary_array = $summary_listing_totals;
			$summary_listing_totals = new stdClass;
			$summary_listing_totals_array = $this->array_to_object(array_slice($new_summary_array, (1-1)*ITEMS_PER_PAGE_DEFAULT, $size));
			$summary_listing_totals = $this->array_to_object($summary_listing_totals_array);
		}
	
		//Set view or export view
		if($export){
		//Setting Excel 

		$totalCount = count((array)$SummaryListingExport);
		$newRowNumber = $totalCount + 1;
		$SummaryListingExport->$totalCount = new StdClass;
		$SummaryListingExport->$totalCount->userSN = '';
		$SummaryListingExport->$totalCount->userGivenname = '';
		$SummaryListingExport->$totalCount->username = '';
		$SummaryListingExport->$totalCount->userMail = '';
		$SummaryListingExport->$totalCount->facilityName = '';
		$SummaryListingExport->$totalCount->userStatus = '';
		$SummaryListingExport->$totalCount->user_ext_mail = 'VA Total:';
		$SummaryListingExport->$totalCount->userNumber_of_sent = $this->sum_by_object_name((array)$SummaryListingExport, 'userNumber_of_sent');
		$SummaryListingExport->$totalCount->userNumber_of_seen = $this->sum_by_object_name((array)$SummaryListingExport, 'userNumber_of_seen');
		$SummaryListingExport->$totalCount->userTotal_of_messages = $this->sum_by_object_name((array)$SummaryListingExport, 'userTotal_of_messages');

		$this->export(array('Last Name', 'First Name','Username','Direct Address','VA Facility','User Status', 'VA email Address', 'Total Messages Sent', 'Total Messages Received', 'Total Messages'),$SummaryListingExport,'User Activity Summary',$items,$between,$selected,$ldapfilters);
		
		}
		else if($export_pdf) {
			if (!empty($SummaryListingExport_2)){
				$data['summary_list'] = $SummaryListingExport_2;
			}else{
				$data['summary_list'] = $SummaryListingExport;
			}
			$html = $this->load->view('api/reports/result_tables/result_user_activity_summary', $data, true);
			$this->export_pdf('User Activity Summary.pdf', $html);
		} 
		else if($print_page) {
			$this->clear_cache();
			if (!empty($SummaryListingExport_2)){
				$data['summary_list'] = $SummaryListingExport_2;
			}
			else { $data['summary_list'] = $SummaryListingExport; }
			$data['print_page'] = true;
			$this->load->view('api/reports/result_tables/result_user_activity_summary', $data);
		}
		else{
			$data['summary_list_totals'] = $summary_listing_totals;
			$this->load->view('api/reports/user_activity_summary', $data);
		}
	
	}

	//converts the id into the name based on what type it is
	private function id_to_name($type,$id){
		$this->load->model('accountrequestmodel');
		$data=array();
		switch ($type){
			case 3://a user
				$name=$this->usersmodel->get_username_from_id($id);
				if($name){
					$data['id'] = $name;
				}
				else{
					$data['id'] = "N/A";
				}
				$data['type']="User";
				break;
			case 2://an application
				$name = $this->applicationmodel->get_application($id)->result();
				if($name){
					$data['id'] = $name[0]->name;
				}
				else{
					$data['id'] = "N/A";
				}
				$data['type'] = "Application";
				break;
			case 1://an application request
				$data['type'] = "App Request";
				$request = $this->applicationrequestmodel->get_request($id);
				if($request) {
					$name = $request->result();
					if($name){ $data['id'] = $name[0]->name; }
				}
				if(!isset($data['id'])) { $data['id'] = 'N/A'; }
				break;
			case 4://user request
				$data['type'] = "User Request";
				$request = $this->accountrequestmodel->get_request($id);
				if($request) {
					$name = $request->result();
					if($name){ $data['id'] = $name[0]->user_org_id; }
				}
				if(!isset($data['id'])) { $data['id'] = 'N/A'; }
				break;
			case 5://category
				$data['type'] = "Category";
				$request = $this->ticketcategorymodel->get_category($id);
				if($request) {
					$name = $request->result();
					if($name){ $data['id'] = $name[0]->category; }
				}
				if(!isset($data['id'])) { $data['id'] = 'N/A'; }
				break;
			case 6://group
				$data['type'] = "Group";
				if(!isset($data['id'])) { $data['id'] = 'N/A'; }
				break;
			case 7://facility
				$request = $this->facilitymodel->get_facility($id);
				$data['type'] = "Facility";
				if($request) {
					$name = $request->result();
					if($name){ $data['id'] = $name[0]->name; }
				}
				if(!isset($data['id'])) { $data['id'] = 'N/A'; }
				break;
			case 8://Message
				$data['type'] = "Search";
				if($id){
					$data['id'] = $id;
				}
				else { $data['id'] = 'N/A'; }
				break;
		}
		return $data;
	}
	
	private function get_type($id) {
		switch ($id){
			case 3:
				return "User";
			case 2://an application
				return "Application";
			case 1://an application request
				return "App Request";
			case 4://user request
				return "User Request";
			case 5://category
				return "Category";
			case 6://group
				return "Group";
			case 7://facility
				return "Facility";
			case 8://Message
				return "Search";
		}
	}
	
	//chooses which (asc or desc) the table should be
	private function direction_check($order,$lastorder,$direction,$change){
		//reloaded by filter and not clicking to change direction.  also make sure that it was not changed by user
		if ($change == 'false' && ($direction == "DESC" || $direction == "ASC")){
			return $direction;
		}
		//colum selected is same as last
		if($order == $lastorder){
			if($direction == 'DESC'){
				return 'ASC';
			}
			else{
				return "DESC";
			}
		}
		//clicked on new colum
		else{ 
			return "DESC";
		}
	}
	/* This function returns the values of sum */
	function sum_by_object_name(array $arr, $property) {
		$sum = 0;  
		foreach($arr as $object) {
			$sum += isset($object->{$property}) ? $object->{$property} : 0;
		}
		return $sum;
	}	
	
	//sets date if date is not formatted properly
	private function check_date($start, $end){
		$dates = array();
		//checks to see if start date is valid
		if(($st=strtotime($start)) == TRUE){ $dates['start'] = $st; }
		//default to earliest possible date
		else{ $dates['start'] = null; }
		
		//check to see if end date is valid
		//set to date plus one sec under 24 hours to get everything on that day
		if(($en=strtotime($end)) == TRUE){ $dates['end'] = $en; }
		//default to tomorrow to include everything
		else { $dates['end'] = null; }
	
		return $dates;
	}
	//sets value of search based on what type of comparison
	private function search_type($value,$type){
		
		if($value == ''){//if no value ignore type
			return "%";
		}
		
		switch ($type){
			case 'equals':
				return $value;
				break;
			case 'contains':
				return "%".$value."%";
				break;
			case 'starts':
				return $value."%";
				break;
			case 'ends':
				return "%".$value;
				break;
			default:
				return $value;
				break;
		}
	}
	
	//sets value of search based on what type of comparison
	private function search_type_for_array($value,$type){
		
		if($value == ''){//if no value ignore type
			return "%";
		}
		
		switch ($type){
			case 'equals':
				return "/^".$value."$/i";
				break;
			case 'contains':
				return "/".$value."/i";
				break;
			case 'starts':
				return "/^".$value."/i";
				break;
			case 'ends':
				return "/".$value."$/i";
				break;
			default:
				return "/^".$value."$/i";
				break;
		}
	}
	//gets the ids from each of the tabels to add  them to the query
	private function names_to_ids($idsql,$typesql,$name,$type){
		$this->load->model('accountrequestmodel');
		$sql = "";
		if($type == "3" || $type == "(ALL)"){//if it is a user
			if($typesql){
				$sql .= "(".$typesql." = 3 AND (";
			}
			else{
				$sql .= "((";
			}
			$add = "(2=1)";
			if($name=='%'){//if blank dont even search
				$add .= " OR (1 = 1)";
			}
			else{
				$results=$this->usersmodel->get_ids_from_username($name)->result();//search for ids like name
				foreach($results as $result){//add each username to 	
					$add .= " OR (".$idsql." = ". $result->user_id.")";
				}
			}
			$sql .=$add."))";
		}
		if($type == "2" || $type == "(ALL)"){//if application
			if($sql != ""){
				$sql .= " OR ";
			}
			if($typesql){
				$sql .= "(".$typesql." = 2 AND (";
			}
			else{
				$sql .= "((";
			}
			$add = "(2=1)";
			if($name=='%'){
				$add .= " OR (1 = 1)";
			}
			else{
				$results=$this->applicationmodel->get_ids($name)->result();
				foreach($results as $result){	
					$add .= " OR (".$idsql." = ". $result->id.")";
				}
			}
			$sql .=$add."))";
		}
		if($type == "1" || $type == "(ALL)"){//if application request
			if($sql != ""){
				$sql .= " OR ";
			}
			if($typesql){
				$sql .= "(".$typesql." = 1 AND (";
			}
			else{
				$sql .= "((";
			}
			$add = "(2=1)";
			if($name=='%'){
				$add .= " OR (1 = 1)";
			}
			else{
				$results=$this->applicationrequestmodel->get_ids($name)->result();
				foreach($results as $result){
					$add .= " OR (".$idsql." = ". $result->id.")";
				}
			}
			$sql .=$add."))";
			
		}
		if($type == "4" || $type == "(ALL)"){//if user request
			if($sql != ""){
				$sql .= " OR ";
			}
			if($typesql){
				$sql .= "(".$typesql." = 4 AND (";
			}
			else{
				$sql .= "((";
			}
			$add = "(2=1)";
			if($name=='%'){
				$add .= " OR (1 = 1)";
			}
			else{
				$results=$this->accountrequestmodel->get_ids($name)->result();
				foreach($results as $result){
					$add .= " OR (".$idsql." = ". $result->id.")";
				}
			}
			$sql .=$add."))";
			
		}
		if($type == "6" || $type == "(ALL)"){//groups
			if($sql != ""){
				$sql .= " OR ";
			}
			if($typesql){
				if($name == '%'){
					$sql .= "(".$typesql." = 6)";
				}
				else{
					$sql .= "(".$typesql." = 6 AND ".$idsql." like ".$this->db->escape($name).")";
				}
			}
				
		}
		if($type == "8" || $type == "(ALL)"){//messages
			if($sql != ""){
				$sql .= " OR ";
			}
			if($typesql){
				if($name == '%'){
					$sql .= "(".$typesql." = 8)";
				}
				else{
					$sql .= "(".$typesql." = 8 AND ".$idsql." like ".$this->db->escape($name).")";
				}
			}
		
		}
		if($type == "5"){//if user using org id
			if($name=='%'){
				$sql .='(1=1)';
			}
			else{
				$results=$this->usersmodel->get_orgs_from_username($name)->result();
				$sql.= "(2=1)";
				foreach($results as $result){	
					$sql .= " OR (".$idsql." = ". $result->user_org_id.")";
				}
			}
		}
		return $sql;
	}
	
	//generates and returns respose for filtered query
	private function reports_helper($table,$items,$between,$selector,$typesearch,$order,$dir,$page,$export,$items_per_page) {
		$sql = '0=0';//always true statment to start query
		//add each item to query
		foreach ($items as $key => $value){//this if for search field
			if($value!="%"){
				$sql = $sql." AND (". $key ." like ". $this->db->escape($value).")";
			}
		}
		foreach ($between as $key => $value){//this if for anything that has an upper and lower boundary (ie date)
			if($value['end']){
				$sql = $sql." AND (". $key ." <= ".$this->db->escape($value['end']).")";
			}
			if($value['start']){
				$sql = $sql." AND (". $key ." >= ".$this->db->escape($value['start']).")";
			}
			 
			
		}
		foreach ($selector as $key => $value){//this if for ones with a drop down menu
			if($value == "(ALL)"){
				$sql = $sql." AND (". $key ." like '%' OR ".$key." IS NULL)";
			}
			else{
				$sql = $sql." AND (". $key ." like ". $this->db->escape($value).")";
			}
		}
				
		foreach($typesearch as $key => $value){//this if for inputs that have different types and their ids refer to different entries on different tables
			if(!($value['type']=="(ALL)"&&$value['name']=="%")){
				$sql = $sql." AND (". $this->names_to_ids($key,$value['typesql'],$value['name'],$value['type']) .")";
			}
		}
		$order = str_replace("'","",$this->db->escape($order)). " ". $dir. ",id ". $dir ;//what to order values into
		//get starting point based on page number
		if(!$page){
			$page = 1;
		}
		$page = (($page-1)*$items_per_page)+1;
		switch($table){//choose what reports you are looking at
			case 'request':
				//get size
				$size = $this->requestmodel->get_filted_size($sql)->result();
				$size = $size[0]->count;
				if($export){//if export get all pages
					if(strpos($order, 'application_id') !== FALSE){//if sorting by application_id
						//$responses_list = $this->requestmodel->get_request_filter_export_app_order($sql,$order)->result();
							$responses_list= $this->requestmodel->get_request_filter_app_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
					
					}
					else{
						//$responses_list = $this->requestmodel->get_request_filter_export($sql,$order)->result();
						$responses_list= $this->requestmodel->get_request_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
					
					}
				}
				else{
					//if you are on a page larger then what the size will be go back to first page
					if($size<$page){
						$page = 1;
					}
					if(strpos($order, 'application_id') !== FALSE){//if sorting by application_id
						$responses_list= $this->requestmodel->get_request_filter_app_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}
					else{
						$responses_list= $this->requestmodel->get_request_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}
				}
				break;
			case 'event':
				$size = $this->eventmodel->get_filted_size($sql)->result();
				$size = $size[0]->count;
				if($export){//if export get all pages
					$responses_list = $this->eventmodel->get_event_filter_export($sql,$order)->result();
				}
				else{
					if($size<$page){//if you are on a page larger then what the size will be go back to first page
						$page = 1;
					}
					$responses_list= $this->eventmodel->get_event_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
				}
				break;
			case 'login':
				$size = $this->loginsmodel->get_filted_size($sql)->result();
				$size = $size[0]->count;
				
				if($export){//export get all pages
					if(strpos($order, 'user_id') !== FALSE){//ordered by user id
						$responses_list = $this->loginsmodel->get_login_filter_export_user_order($sql,$order)->result();
					}
					else{
						$responses_list = $this->loginsmodel->get_login_filter_export($sql,$order)->result();
					}
				}
				else{
					if($size < $page){//if you are on a page larger then what the size will be go back to first page
						$page = 1;
					}
					if(strpos($order, 'user_id') !== FALSE){//ordered by user id
						$responses_list= $this->loginsmodel->get_login_filter_user_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}
					else{
						$responses_list= $this->loginsmodel->get_login_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}
				}
				break;
			case 'mail':
				$size = $this->mailmodel->get_filted_size($sql)->result();
				$size = $size[0]->count;
				if($export){ //export get all pages
					$responses_list = $this->mailmodel->get_mail_filter_export($sql,$order)->result();
				}
				else{
					if($size<$page){//if you are on a page larger then what the size will be go back to first page
						$page = 1;
					}
					$responses_list= $this->mailmodel->get_mail_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
				}
				break;	
			case 'tickets':
				$size = $this->ticketsmodel->get_filtered_size($sql)->result();
				$size = $size[0]->count;
				if($export){ //export get all pages
					if (strpos($order, 'user_id') !== FALSE){
						$responses_list = $this->ticketsmodel->get_tickets_filter_export_user_order($sql,$order)->result();
					}else if(strpos($order, 'category_id') !== FALSE){
						$responses_list = $this->ticketsmodel->get_tickets_filter_export_category_order($sql,$order)->result();
					}else{
						$responses_list = $this->ticketsmodel->get_tickets_filter_export($sql,$order)->result();
					}
				}
				else{
					if($size<$page){//if you are on a page larger then what the size will be go back to first page
						$page = 1;
					}
					if (strpos($order, 'user_id') !== FALSE){
						$responses_list= $this->ticketsmodel->get_tickets_filter_user_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}else if(strpos($order, 'category_id') !== FALSE){
						$responses_list= $this->ticketsmodel->get_tickets_filter_category_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}else{
						$responses_list= $this->ticketsmodel->get_tickets_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}
				}
				break;
			case 'facility':
				//getting size number
				$size = $this->facilitymodel->get_facility_list_size_reports_sql($sql)->result();
				$size = $size[0]->count;
				if($export){//if export get all pages
					$responses_list= $this->facilitymodel->get_request_filter_facility_order_export($sql,$order,$this->db->escape($page),$items_per_page)->result();
				} else { //if you are on a page larger then what the size will be go back to first page
					if($size<$page){
						$page = 1;
					}
					if(strpos($order, 'name') !== FALSE){//if sorting by name
						$responses_list= $this->facilitymodel->get_request_filter_facility_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}
					else{
						$responses_list= $this->facilitymodel->get_request_filter_facility($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}
				}
				break;
			case 'user_activity_summary':
				//getting size number
				$size = $this->useractivitysummarymodel->get_user_list_size($sql)->result();
				$size = $size[0]->count;
				if($export){//if export get all pages
					$responses_list= $this->useractivitysummarymodel->get_request_filter_user_activities_export($sql,$order,$this->db->escape($page),$items_per_page)->result();
				} else { //if you are on a page larger then what the size will be go back to first page
					if($size<$page){
						$page = 1;
					}
					$responses_list= $this->useractivitysummarymodel->get_request_filter_user_activities($sql,$order,$this->db->escape($page),$items_per_page)->result();
				}
				break;	
			default: //tries to call a bad reports table
				//print_r ("Bad Table"); //debugging only
				//exit(-1); //debugging only
				break;
		}
		$response=array(
			'size'=>$size,
			'response'=>$responses_list
		);
		return $response;
		
	}
	
	/*
	 * export is used for exporting the results to excel 
	 */
	private function export($header,$results,$name,$items,$between,$selected,$ldap){
		header('Content-Type: application/download'); 
		header('Content-Transfer-Encoding: binary');
        header('Content-Disposition: attachment; filename="'.$name.'.csv"');
		$fp = fopen('php://output', 'w');
		$date = date('m/d/Y h:i:s A', time());
		$date = ' ' . (string)$date;
		fputcsv($fp,  array('FOR OFFICIAL USE ONLY', '', '', 'Report generated by '.$this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'], '', '', '', $date, '', ''));
		$activeFilters = array($this->export_info($items,$between,$selected,$ldap), '', '', '');
		fputcsv($fp, $activeFilters);
		fputcsv ($fp, $header);
		foreach($results as $result) {
			$row=array();
			foreach($result as $part) {
				array_push($row,$part);
			}
			fputcsv ($fp, $row);
		}
		
		fclose($fp);
	}
	
	private function export_pdf($file_name, $html) {
		
		$pdf = new WkHtmlToPdf(array(
				'binPath' => WKHTMLTOPDF_EXE_PATH
		));
		// Add a HTML string
		$pdf->addPage($html);
		if(!$pdf->send($file_name))
			throw new Exception('Could not create PDF: '.$pdf->getError());
	}
	
	private function export_info($items,$between,$selected,$ldap) {
		
		$filters = 'Active Filters: ';
		if ($items != null) {
			foreach ($items as $key => $value){
				if($value!="%" && $value != '(ALL)'){
					if ($value[0]=='%' && substr($value, -1)=='%') $value = 'contains: ' . trim($value, '%');
					elseif ($value[0]=='%') $value = 'ends with: ' . trim($value, '%');
					elseif (substr($value,-1)=='%') $value = 'starts with: ' . trim($value, '%');
					else {
						$value = 'equals: ' . $value;
					}
					if($key=='id') $pair = 'ID ' . $value;
					if($key=='session_id') $pair = 'Session ID ' . $value;
					if($key=='name') $pair = 'Name ' . $value;
					if($key=='message') $pair = 'Message ' . $value;
					if($key=='org_id') $pair = 'Org ID ' . $value;
					if($key=='call') $pair = 'Call ' . $value;
					if($key=='response') $pair = 'Response ' . $value;
					if($key=='response_code') $pair = 'Response Code ' . $value;
					if($key=='parent_id') $pair = 'Parent ID ' . $value;
					if($key=='action') $pair = 'Action ' . $value;
					if($key=='ip_address') $pair = 'IP Address ' . $value;
					if($key=='error_msg') $pair = 'Error Message ' . $value;
					if($key=='size') $pair = 'Size ' . $value;
					if($key=='attachment_types') $pair = 'Attachment Types ' . $value;
					if($key=='sender') $pair = 'Sender ' . $value;
					if($key=='recipient') $pair = 'Recipient ' . $value;
					if($key=='U.username') $pair = 'Username ' . $value;
					if($key=='user_ext_mail') $pair = 'VA Email Address ' . $value;
					if($key=='actor') $pair = 'Actor ' . $value;
					if($key=='target') $pair = 'Target ' . $value;
					if($key=='user_id') $pair = 'User ' . $value;
					if($key=='is_active') {
						if ($value == 'equals: 1') $pair = 'User Status: Active';
						else $pair = 'User Status: Inactive';
					}
					$filters = $filters . ' ' . $pair . ', ';
				}
			}
		}
		if ($ldap!=null) {
			foreach ($ldap as $filter) {
				$filters = $filters . ' ' . $filter . ', ';
			}
		}
		foreach ($between as $key => $value){
			if($value['start']){
				$pair = 'Start date: ' . date('m/d/Y h:i:s A', $value['start']);
				$filters = $filters . ' ' . $pair . ', ';
			}
			if($value['end']){
				$pair = 'End date: ' . date('m/d/Y h:i:s A', $value['end']);
				$filters = $filters . ' ' . $pair . ', ';
			}
		}
		if($selected!=null){
			if (is_array($selected) && count($selected)>0) {
				foreach ($selected as $choice) {
					if ($choice != null) {
						$filters = $filters . ' ' . $choice . ', ';
					}
				}
			}
			else {
				$filters = $filters . ' ' . $selected;
			}
		}
		if (substr($filters, -2) ==", ") {
			$filters = substr($filters, 0, -2);
		}
		
		if (strlen($filters) === 16){
			$filters = $filters.'None';
		}
		return $filters;
	}
	
	/*
	 * checks if dates are valid and returns a warning message if not
	 */
	private function get_date_filter_validation_message($dates) {
		$invalid_date = 0;
		$warning_message = null;
		foreach($dates as $date) {
			if(!empty($date) && !strtotime($date)) {
				$invalid_date = $invalid_date + 1;
			}
		}
		if($invalid_date > 1) { $warning_message = 'The invalid date inputs have been ignored.'; }
		else if($invalid_date > 0) { $warning_message = 'The invalid date input has been ignored.'; }

		return $warning_message;
	}

	//Setting Object to Array
	private function object_to_array($object)
	 {
	  if (is_object($object))
	  {
	   // Gets the properties of the given object with get_object_vars function
	   $object = get_object_vars($object);
	  }
	 
	   return (is_array($object)) ? array_map(array($this,__FUNCTION__), $object) : $object;
	 }
	//Setting Array to Object
	private function array_to_object($array)
	 {
	  return (is_array($array)) ? (object) array_map(array($this,__FUNCTION__), $array) : $array;
	 }
	//Sort the array based on key
	private function sortBy($field, &$array, $direction)
	{
		if(ctype_alpha($field) && ctype_alpha($direction)){
			usort($array, create_function('$a, $b', '
				$a = strtoupper($a["' . $field . '"]);
				$b = strtoupper($b["' . $field . '"]);
		
				if ($a == $b)
				{
					return 0;
				}
		
				return ($a ' . ($direction == 'DESC' ? '>' : '<') .' $b) ? -1 : 1;
				'));
		
			return true;
		}
		return false;
	}
	private function array_multi_search_filter( $array, $index, $pattern, $invert = FALSE )
	{

		$output = array();

		foreach ( $array as $i => $arr )
		{

			// The index must exist and match the pattern
			if ( isset( $arr[ $index ] ) && ( bool ) $invert !== ( bool ) preg_match( $pattern, $arr[ $index ] ) )
			{
				$output[ $i ] = $arr;
			}

		}

		return $output;

	}
	
	private function create_tabs($selected){
		$this->verify_access($selected);
		$html = '<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">';
		foreach ($this->report_tabs as $key => $value){
			if($this->has_access($key."_report")){
				if(($key."_report") === $selected){
					$html.= '<li class="reports-tab ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="/reports/'.$key.'">'.$value.'</a></li>';
				}else{
					$html .= '<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/'.$key.'">'.$value.'</a></li>';
				}
				
			}
		}	
		$html .= '</ul>';
		return $html;
	}
	
	private function clear_cache() {
		header("Expires: ".gmdate("D, d M Y H:i:s", time())." GMT");
		header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
		header("Cache-Control: no-cache, must-revalidate");
		header("Pragma: no-cache");
	}
}
